//
//  OPDataOperation.h
//  Image Downloader
//
//  Created by Nathan Van Fleet on 2015-05-29.
//  Copyright (c) 2015 Nathan Van Fleet. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreGraphics/CGBase.h>
#import "OPDataMonitorProtocol.h"

typedef NS_ENUM(NSUInteger, OPProfileImage) {
	OPProfileImageLargeFormat, // B5 only, need source image of 256 x 256
	OPProfileImageMainLock,
	OPProfileImageHelperLock,
	OPProfileImageMainToolbar,
	OPProfileImageHelperToolbar,
	OPProfileImageMenu,
	OPProfileImageSidebar,
	OPProfileImageSyncPreferences,
	OPProfileImageSettings,
#if TARGET_OS_IPHONE
	OPProfileImageNavigationBar,
#endif
};

typedef NS_ENUM(NSUInteger, OPCategoryImage) {
	OPCategoryImageDetail,
	OPCategoryImageList,
	OPCategoryImageMenu,
	OPCategoryImageSource,
};

typedef NS_ENUM(NSUInteger, OPItemImage) {
	OPItemImageDetail,
	OPItemImageList,
	OPItemImageMini,
};

@class OPItem;
@protocol OPGenericProfile;
@protocol OPGenericCategory;

@interface OPImageDataOperation : NSObject

// Vault Icons
+ (id <OPImageDataOperationMonitor>)dataOperationForProfile:(id<OPGenericProfile>)profile imageType:(OPProfileImage)imageType completion:(void(^)(id image, NSError *error))completionBlock;

// Category Icons
+ (id <OPImageDataOperationMonitor>)dataOperationForCategory:(id<OPGenericCategory>)category imageType:(OPCategoryImage)imageType profile:(id<OPGenericProfile>)profile completion:(void(^)(id image, NSError *error))completionBlock;

// Item Icons
+ (id <OPImageDataOperationMonitor>)dataOperationForItem:(OPItem *)item imageType:(OPItemImage)imageType imageScale:(CGFloat)scale completion:(void(^)(id image, NSError *error))completionBlock;
@end
